#ifndef OURDREAM_2D_GUISYSTEM_H
#define OURDREAM_2D_GUISYSTEM_H

#include "ComDef.h"
#include "IInterface.h"
#include "RenderSystem.h"
#include "InputSystem_Win32.h"

#pragma comment(lib, "imm32.lib")

// GUI
enum EGUIObjType
{
	EGUIT_UNKNOW=0,
	EGUIT_LABEL=1,
	EGUIT_BUTTON=2,
	EGUIT_CHECKBOX=3,
	EGUIT_IMAGEBOX=4,
	EGUIT_PROGRESSBAR=5,
	EGUIT_RADIOBOX=6,
	EGUIT_SCROLLBAR=7,
	EGUIT_LISTBOX=8,
	EGUIT_EDITBOX=9,
	EGUIT_WEDITBOX=10,
	EGUIT_WINDOW=11
};
// ¼
enum EEventReceiverType
{
	EERT_MOUSE_LEFTBUTTON_DOWN=1,
	EERT_MOUSE_LEFTBUTTON_UP=2,
	EERT_MOUSE_RIGHTBUTTON_DOWN=3,
	EERT_MOUSE_RIGHTBUTTON_UP=4,
	EERT_MOUSE_MOVEON=5
};

enum EGUIValueType
{
	EGUIVT_FRECT_POSITION=1,
	EGUIVT_FRECT_NORMALTEXTURECOORD=2,
	EGUIVT_FRECT_HOTTEXTURECOORD=3,
	EGUIVT_FLOAT_GLINTTIME=4,
	EGUIVT_FLOAT_MAXVALUE=5,
	EGUIVT_FLOAT_MINVALUE=6,
	EGUIVT_FLOAT_CURVALUE=7,
	EGUIVT_INT_FONTID=8,
	EGUIVT_INT_NORMALTEXTUREID=9,
	EGUIVT_INT_HOTTEXTUREID=10,
	EGUIVT_BOOL_SHADOW=11,
	EGUIVT_BOOL_GLINT=12,
	EGUIVT_BOOL_FRAME=13,
	EGUIVT_BOOL_FRAMEFILL=14,
	EGUIVT_BOOL_BEPRESS=15,
	EGUIVT_BOOL_BEMOVEON=16,
	EGUIVT_BOOL_BESELECT=17,
	EGUIVT_BOOL_ISEMPTY=18,
	EGUIVT_BOOL_ISBEGIN=19,
	EGUIVT_BOOL_ISEND=20,
	EGUIVT_DWORD_NORMALCOLOR=21,
	EGUIVT_DWORD_HOTCOLOR=22,
	EGUIVT_DWORD_FRAMECOLOR=23,
	EGUIVT_DWORD_FONTCOLOR=24,
	EGUIVT_STRING_CAPTURE=25,

	EGUIVT_LISTITEM_ADD=26,
	EGUIVT_LISTITEM_DEL=27,
	EGUIVT_LISTITEM_DELALL=28,
	EGUIVT_LISTITEM_GET=29,
	EGUIVT_INT_CURSELECT=30
};
// б
struct SListItem
{
	int m_iID;
	LPSTR m_lpText;
	long m_lValue;
};

// ӿ
class CGUISystem : public IInterface
{
public:
	//////////////////////////////////////////////////////////////////////////
	// Ҫ
	virtual int CALL OnEven(void)=0;
	virtual void CALL RenderAll(void)=0;
	virtual void CALL Release(void)=0;
	//////////////////////////////////////////////////////////////////////////
	// 
	virtual void CALL DelGUIObj(int ID, int father=-1)=0;
	virtual void CALL DelAll(void)=0;
	//////////////////////////////////////////////////////////////////////////
	// GUI
	virtual void CALL SetEvenReceiver(int ID, EEventReceiverType receivertype, OD2DCallback receiver, int father=-1)=0;
	virtual void CALL SetFocusToThis(int ID)=0;
	virtual bool CALL IsThisHasFocus(int ID)=0;
	virtual void CALL HideGUIObj(int ID)=0;
	virtual void CALL ShowGUIObj(int ID)=0;
	virtual bool CALL IsThisHide(int ID)=0;
	virtual void CALL DisableGUIObj(int ID)=0;
	virtual void CALL EnableGUIObj(int ID)=0;
	virtual bool CALL IsThisDisable(int ID)=0;

	virtual void CALL SetGUIObjValue(int ID, EGUIValueType type, float value)=0;
	virtual void CALL SetGUIObjValue(int ID, EGUIValueType type, int value)=0;
	virtual void CALL SetGUIObjValue(int ID, EGUIValueType type, SOD2DFloatRect value)=0;
	virtual void CALL SetGUIObjValue(int ID, EGUIValueType type, DWORD value)=0;
	virtual void CALL SetGUIObjValue(int ID, EGUIValueType type, LPSTR value)=0;
	virtual void CALL SetGUIObjValue(int ID, EGUIValueType type, bool value)=0;

	virtual void CALL SetListBoxItemValue(int ID, EGUIValueType type, SListItem item)=0;
	virtual SListItem * CALL GetListBoxItemValue(int ID, EGUIValueType type, int value)=0;

	virtual float CALL GetGUIObjFloatValue(int ID, EGUIValueType type)=0;
	virtual int CALL GetGUIObjIntValue(int ID, EGUIValueType type)=0;
	virtual SOD2DFloatRect CALL GetGUIObjFRectValue(int ID, EGUIValueType type)=0;
	virtual DWORD CALL GetGUIObjDwordValue(int ID, EGUIValueType type)=0;
	virtual LPSTR CALL GetGUIObjStringValue(int ID, EGUIValueType type)=0;
	virtual LPWSTR CALL GetGUIObjWStringValue(int ID, EGUIValueType type)=0;
	virtual bool CALL GetGUIObjBoolValue(int ID, EGUIValueType type)=0;
	//////////////////////////////////////////////////////////////////////////
	// GUIӺ
	
	// ǩ
	virtual void CALL AddLabel(int ID, SOD2DFloatRect position, int FontID, DWORD color, LPSTR capture, bool shadow, bool glint, float glinttime, bool frame, bool fill, DWORD framecolor, int father=-1)=0;
	// Ť
	virtual void CALL AddButton(int ID, SOD2DFloatRect position, int FontID, DWORD fontcolor, LPSTR capture, 
								bool fontshadow, bool fontglint, float glinttime, DWORD normalcolor, DWORD hotcolor, 
								int normaltexture, SOD2DFloatRect normaltexturecoord, 
								int hottexture, SOD2DFloatRect hottexturecoord,
								int father=-1)=0;
	// ѡ
	virtual void CALL AddCheckBox(int ID, SOD2DFloatRect position, int FontID, DWORD fontcolor, LPSTR capture, 
								bool fontshadow, bool fontglint, float glinttime, DWORD normalcolor, DWORD hotcolor, 
								int normaltexture, SOD2DFloatRect normaltexturecoord, 
								int hottexture, SOD2DFloatRect hottexturecoord,
								int father=-1)=0;
	// б
	virtual void CALL AddListBox(int ID, SOD2DFloatRect position, int FontID, DWORD fontcolor, 
								DWORD normalcolor, DWORD hotcolor, int texture, SOD2DFloatRect texturecoord,
								int father=-1)=0;
	// ͼƬ
	virtual void CALL AddImageBox(int ID, SOD2DFloatRect position, DWORD color, int textureID, SOD2DFloatRect texturecoord,
									int father=-1)=0;
	// ༭
	virtual void CALL AddEditBox(int ID, SOD2DFloatRect position, DWORD color, DWORD boxcolor, DWORD caretcolor, 
								DWORD selectboxcolor, int font, DWORD fontcolor, int texture, SOD2DFloatRect texturecoord, bool showcraet=true, int father=-1)=0;
	// ı༭
	virtual void CALL AddWEditBox(int ID, SOD2DFloatRect position, DWORD color, DWORD boxcolor, DWORD caretcolor, 
									DWORD selectboxcolor, int font, DWORD fontcolor, int texture, SOD2DFloatRect texturecoord, bool showcraet=true, int father=-1)=0;

	// 
	virtual void CALL AddWindow(int ID, SOD2DFloatRect position, DWORD headcolor, DWORD maincolor, int headtexture, SOD2DFloatRect headtexturecoord,
								int maintexture, SOD2DFloatRect maintexturecoord, int font, DWORD fontcolor, LPSTR capture)=0;
	// 
	virtual void CALL AddProgressBar(int ID, SOD2DFloatRect position, DWORD color, float maxvalue, float minvalue, float curvalue=0, int father=-1)=0;
	// 
	virtual void CALL AddScrollBar(int ID, SOD2DFloatRect position, bool plumb, DWORD slidecolor, DWORD slipcolor, int slidetextureID, SOD2DFloatRect slidetexcoord, int sliptextureID, SOD2DFloatRect sliptexcoord, 
									float maxvalue, float minvalue, float curvalue=0, int father=-1)=0;
	// ѡ
	virtual void CALL AddRadioBox(int ID, SOD2DFloatRect position, int FontID, DWORD fontcolor, LPSTR capture, 
								bool fontshadow, bool fontglint, float glinttime, DWORD normalcolor, DWORD hotcolor, 
								int normaltexture, SOD2DFloatRect normaltexturecoord, 
								int hottexture, SOD2DFloatRect hottexturecoord,
								int father=-1)=0;
};

#endif